{* Calculate title from path *}
{capture name="title"}
   {if count($path) > 1} - {/if}
   {foreach from=$path item=category name=path}
      {if $smarty.foreach.path.iteration gt 2}
         &gt;
      {/if}
      {if not $smarty.foreach.path.first}
         {$category.TITLE}
      {/if}
   {/foreach}
{/capture}

{strip}
{if $title_prefix}
   {assign var="in_page_title" value=$title_prefix|cat:$category.TITLE}
{else}
   {assign var="in_page_title" value=$category.TITLE}
{/if}
{assign var="description" value=$category.DESCRIPTION}

{include file="header.tpl"}

{include file="top_bar.tpl"}

{* Calculate the number of categories per row *}
{php}
   $this->assign('cats_per_col', ceil(count($this->get_template_vars('categs')) / CATS_PER_ROW));
{/php}

{if $cats_per_col > 15}
   {php}
      $this->assign('cats_per_col', ceil(count($this->get_template_vars('categs')) / (CATS_PER_ROW + 1)));
   {/php}
{/if}

{* Categories *}
{if !empty($categs)}
   <div class="categories">
      {if !empty($category.ID)}
      {/if}
	  	  <div class="caption"><p></p><h2>{if $category.ID==0}Browse Directory{else}Category{/if}</h2></div>
	  <div class="mainbox2">
      <table border="0" cellpadding="0" cellspacing="0" width="100%">
      <tr>
         {foreach from=$categs item=cat name=categs}
         {if ($smarty.foreach.categs.iteration mod $cats_per_col eq 1 and $cats_per_col gt 1) or $smarty.foreach.categs.first}<td>{/if}
		 
		 {if $category.ID==0}
		 <br />
		<table cellpadding="0" cellspacing="0" class="b">
			<tr>
				<td><img src="{$smarty.const.DOC_ROOT}/images/btop.left.gif" alt="" /></td>
				<td width="100%"></td>
				<td><img src="{$smarty.const.DOC_ROOT}/images/btop.right.gif" alt="" /></td>
			</tr>
		</table>
		<div class="bbg">
		<div class="cat">
		<a href="{if $smarty.const.ENABLE_REWRITE}{$cat.TITLE_URL|escape}/{else}index.php?c={$cat.ID}{/if}">{$cat.TITLE|escape}</a>{if $smarty.const.CATS_COUNT} <span class="count">({$cat.COUNT})</span>{/if}
		</div>

         {* Display subcategories *}
         {if !empty($cat.SUBCATS)}
         <div class="subcat">
            {foreach from=$cat.SUBCATS item=scat name=scategs}
               <p><a href="{if $smarty.const.ENABLE_REWRITE}{$cat.TITLE_URL|escape}/{$scat.TITLE_URL|escape}/{else}index.php?c={$scat.ID}{/if}">{$scat.TITLE|escape}</a></p>
			{/foreach}
			</div>
			</div>
			<table cellpadding="0" cellspacing="0" class="bbottom">
			  <tr>
				<td><img src="{$smarty.const.DOC_ROOT}/images/bbottom.left.gif" alt="" /></td>
				<td width="100%"></td>
				<td><img src="{$smarty.const.DOC_ROOT}/images/bbottom.right.gif" alt="" /></td>
			  </tr>
			</table>
         {/if}
		 
		{else}
		<div class="catin">
			<p><a href="{if $smarty.const.ENABLE_REWRITE}{$cat.TITLE_URL|escape}/{else}index.php?c={$cat.ID}{/if}">{$cat.TITLE|escape}</a>{if $smarty.const.CATS_COUNT}<span>({$cat.COUNT})</span>{/if}</p>
		</div>
		
		{/if}

         {if ($smarty.foreach.categs.iteration mod $cats_per_col eq 0 and $cats_per_col gt 1) or $smarty.foreach.categs.last}</td>{/if}
         {/foreach}
      </tr>
      </table>
		</div>
		<div class="bottom">
		<p><img src="{$smarty.const.DOC_ROOT}/images/bottom.right.gif" alt="" /></p>
		<img src="{$smarty.const.DOC_ROOT}/images/bottom.left.gif" alt="" />
		</div>
		<br />
{/if}

{if $smarty.const.FTR_ENABLE == 1 and isset($feat_links) and !empty($feat_links)}
<div class="caption"><p></p><h2>Featured Links</h2></div>
<div class="mainbox2">
	{foreach from=$feat_links item=link name=links}
		<table cellpadding="0" cellspacing="0" class="b">
		  <tr>
			<td><img src="{$smarty.const.DOC_ROOT}/images/btop.left.gif" alt="" /></td>
			<td width="100%"></td>
			<td><img src="{$smarty.const.DOC_ROOT}/images/btop.right.gif" alt="" /></td>
		  </tr>
		</table>
		<div class="bbg">
		<div class="fbox">{include file="f.link.tpl" link=$link}</div>
		</div>
		<table cellpadding="0" cellspacing="0" class="bbottom">
		  <tr>
			<td><img src="{$smarty.const.DOC_ROOT}/images/bbottom.left.gif" alt="" /></td>
			<td width="100%"></td>
			<td><img src="{$smarty.const.DOC_ROOT}/images/bbottom.right.gif" alt="" /></td>
		  </tr>
		</table>
		<br />
	{/foreach}
	
	</div>
	<div class="bottom">
	<p><img src="{$smarty.const.DOC_ROOT}/images/bottom.right.gif" alt="" /></p>
	<img src="{$smarty.const.DOC_ROOT}/images/bottom.left.gif" alt="" />
	</div>
	<br />
{/if}




{* Links heading and sorting*}
{if ($qu or $category.ID gt 0 or $p) and isset($links) and !empty($links)}
<div class="caption"><p></p><h2>
	  {if not $p}<span class="sort">{l}Sort by{/l}:
      {if $smarty.const.ENABLE_PAGERANK and $smarty.const.SHOW_PAGERANK}{if $sort eq 'P'} {l}PageRank{/l}{else} <a href="?s=P{if not $smarty.const.ENABLE_REWRITE}&amp;c={$category.ID}{/if}{if $qu}&amp;q={$qu}{/if}{if !empty($p)}&amp;p={$p}{/if}"> {l}PageRank{/l}</a>{/if} |{/if}
      {if $sort eq 'H'} {l}Hits{/l}{else} <a href="?s=H{if not $smarty.const.ENABLE_REWRITE}&amp;c={$category.ID}{/if}{if $qu}&amp;q={$qu}{/if}{if !empty($p)}&amp;p={$p}{/if}">{l}Hits{/l}</a>{/if}
      {if $sort eq 'A'} | {l}Alphabetical{/l}{else} | <a href="?s=A{if not $smarty.const.ENABLE_REWRITE}&amp;c={$category.ID}{/if}{if $qu}&amp;q={$qu}{/if}{if !empty($p)}&amp;p={$p}{/if}">{l}Alphabetical{/l}</a>{/if}
      </span>{/if}

Standard Links</h2></div>

<div class="mainbox2">
{foreach from=$links item=link name=links}
<div class="lbox">{include file="link.tpl" link=$link}</div>
<div class="break"></div>
{/foreach}
</div>
<div class="bottom">
<p><img src="{$smarty.const.DOC_ROOT}/images/bottom.right.gif" alt="" /></p>
<img src="{$smarty.const.DOC_ROOT}/images/bottom.left.gif" alt="" />
</div>
<br />
{/if}


{* Javascript for tracking link clicks *}
<script type="text/javascript">
/* <![CDATA[ */
   var root = '{$smarty.const.DOC_ROOT}';
   {literal}
   var a = document.getElementsByTagName("a");
   for(i = 0; i< a.length; i++)
      if(a[i].id != '')
         a[i].onclick = count_link;
   function count_link() {
      i = new Image();
      i.src= root+'/cl.php?id='+this.id;
      return true;
   }
   {/literal}
/* ]]> */
</script>

{include file="footer.tpl"}
{/strip}